/*
 * Decompiled with CFR 0.152.
 */
package model;

import data.Constants;
import data.Theme;
import model.PlayerModel;
import org.lwjgl.opengl.GL11;
import view.StaticDrawer;

public class EnemyModel {
    public float radius;
    float bandAmpl;
    private int bandNum;
    int sat;
    private float life;
    private float[] eCol;
    private float fStartDist = 0.0f;
    private float fPreviousRadius = 0.0f;
    public float x = 0.0f;
    public float y = 0.0f;
    public float visRadius = 0.0f;

    public EnemyModel(float px, float py, int bN, float bA, int size) {
        float fXDistFromPlayer = px - PlayerModel.x;
        float fYDistFromPlayer = py - PlayerModel.y;
        this.fStartDist = Constants.fPreviewRadiusDistance * (float)Math.sqrt(fXDistFromPlayer * fXDistFromPlayer + fYDistFromPlayer * fYDistFromPlayer);
        this.x = px + 0.5f * fXDistFromPlayer;
        this.y = py + 0.5f * fYDistFromPlayer;
        this.setRadius(size);
        if (this.getRadius() > Constants.MAX_RADIUS) {
            this.setRadius(Constants.MAX_RADIUS);
        } else if (this.getRadius() < Constants.MIN_RADIUS) {
            this.setRadius(Constants.MIN_RADIUS);
        }
        this.setBandNum(bN);
        this.bandAmpl = bA;
        this.life = (float)Constants.FADE_TIME + this.getRadius() * 2.0f + bA * 2.0f;
        this.seteCol(StaticDrawer.getColorValues(this.getBandNum(), 1.0f, true));
    }

    public void draw(float k) {
        float[] fColors = StaticDrawer.getColorValues(this.getBandNum(), k, true);
        this.seteCol(fColors);
        float alpha = this.life / (float)(Constants.FADE_TIME >> 1);
        if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        float fRadius = this.getRadius();
        if (Constants.bPreviewRadius) {
            int iDistFromPlayer = (int)StaticDrawer.distance[(int)Math.abs(this.x - PlayerModel.x)][(int)Math.abs(this.y - PlayerModel.y)];
            if ((float)iDistFromPlayer > this.fStartDist) {
                fRadius += (float)((int)((float)iDistFromPlayer - this.fStartDist) >> 3);
            }
            if (this.fPreviousRadius == 0.0f || fRadius < this.fPreviousRadius) {
                this.fPreviousRadius = fRadius;
            } else {
                fRadius = this.fPreviousRadius;
            }
        }
        GL11.glColor4f(fColors[0], fColors[1], fColors[2], alpha);
        if (Theme.currentTheme == Theme.GLOW_THEME) {
            StaticDrawer.drawRadiance(fRadius, this.getBandNum(), this.x, this.y, fColors[0], fColors[1], fColors[2], alpha);
        } else if (Theme.currentTheme == Theme.SQUARE_THEME) {
            GL11.glRectf(this.x - fRadius, this.y - fRadius, this.x + fRadius, this.y + fRadius);
        }
    }

    public void seekPlayer(float playerX, float playerY) {
        float xDiff = this.x - playerX;
        float yDiff = this.y - playerY;
        this.x -= xDiff / 1000.0f * Constants.ENEMY_SPEED;
        this.y -= yDiff / 1000.0f * Constants.ENEMY_SPEED;
    }

    public void move(float xVel, float yVel) {
        this.x += xVel;
        this.y += yVel;
    }

    public float collide(PlayerModel p) {
        float xDiff = (float)Math.pow(PlayerModel.x - this.x, 2.0);
        float yDiff = (float)Math.pow(PlayerModel.y - this.y, 2.0);
        float dist = (float)Math.sqrt(xDiff + yDiff);
        float satChange = 0.0f;
        if (dist <= p.getCurrentRadius() + this.getRadius()) {
            if (Constants.kirbyMode && p.isHungry()) {
                p.updateBand(this.getBandNum());
                this.life = 0.0f;
                p.setHunger(1.0f);
                return satChange;
            }
            float[] pCol = p.getPlayerColor();
            float[] diffCol = new float[3];
            int i = 0;
            while (i < diffCol.length) {
                diffCol[i] = Math.abs(pCol[i] - this.geteCol()[i]) * 255.0f;
                ++i;
            }
            float radiusPoints = this.radius - Constants.MIN_RADIUS;
            float bandDiff = diffCol[0] + diffCol[1] + diffCol[2];
            float bandPoints = 5.0f / (bandDiff + 1.0f);
            float punishBandPoints = (bandDiff + 1.0f) / 125.0f;
            if (bandDiff > (float)Constants.bandDifference) {
                satChange = (float)((double)satChange + -0.45);
                p.setHunger(0.0f);
                Constants.SCORE = (int)((float)Constants.SCORE + -(10.0f + radiusPoints / 5.0f + punishBandPoints) * (float)Constants.MULTIPLIER);
                if (Constants.SCORE < 0) {
                    Constants.SCORE = 0;
                }
            } else {
                p.updateBand(this.getBandNum());
                satChange = (float)((double)satChange + 0.07);
                Constants.SCORE = (int)((float)Constants.SCORE + (1.0f + radiusPoints / 5.0f + bandPoints) * (float)Constants.MULTIPLIER);
                if (!p.isHungry()) {
                    p.setHunger(1.0f);
                }
            }
            this.life = 0.0f;
        }
        return satChange;
    }

    public float getLife() {
        return this.life;
    }

    public void age() {
        this.life -= 1.0f;
    }

    public void age10() {
        this.life -= 10.0f;
    }

    public float[] geteCol() {
        return this.eCol;
    }

    public void seteCol(float[] eCol) {
        this.eCol = eCol;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public int getBandNum() {
        return this.bandNum;
    }

    public void setBandNum(int bandNum) {
        this.bandNum = bandNum;
    }

    public float getfPreviousRadius() {
        return this.fPreviousRadius;
    }

    public void setfPreviousRadius(float fPreviousRadius) {
        this.fPreviousRadius = fPreviousRadius;
    }
}

